/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client.gui;

import com.cazsius.solcarrot.SOLCarrot;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class PageFlipButton
extends Button {
    private static final ResourceLocation texture = SOLCarrot.resourceLocation("textures/gui/food_book.png");
    public static final int width = 23;
    public static final int height = 13;
    private final Direction direction;
    private final Pageable pageable;

    PageFlipButton(int x, int y, Direction direction, Pageable pageable) {
        super(x, y, 23, 13, (ITextComponent)new StringTextComponent(""), button -> ((PageFlipButton)button).changePage());
        this.direction = direction;
        this.pageable = pageable;
    }

    public void func_230431_b_(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        boolean isHovered;
        if (!this.field_230694_p_) {
            return;
        }
        int textureX = 0;
        boolean bl = isHovered = this.field_230690_l_ <= mouseX && mouseX < this.field_230690_l_ + 23 && this.field_230691_m_ <= mouseY && mouseY < this.field_230691_m_ + 13;
        if (isHovered) {
            textureX += 23;
        }
        int textureY = this.direction == Direction.FORWARD ? 192 : 205;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        this.func_238474_b_(matrices, this.field_230690_l_, this.field_230691_m_, textureX, textureY, 23, 13);
    }

    public void updateState() {
        this.field_230694_p_ = this.pageable.isWithinRange(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    private void changePage() {
        this.pageable.switchToPage(this.pageable.getCurrentPageNumber() + this.direction.distance);
    }

    static interface Pageable {
        public void switchToPage(int var1);

        public int getCurrentPageNumber();

        public boolean isWithinRange(int var1);
    }

    static enum Direction {
        FORWARD(1),
        BACKWARD(-1);

        final int distance;

        private Direction(int distance) {
            this.distance = distance;
        }
    }
}

